/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker;

import com.appdynamics.agent.sim.docker.model.ContainerProcessDtoFactory;
import com.appdynamics.agent.sim.docker.model.DockerContainerFull;
import com.appdynamics.agent.sim.docker.model.IContainerProcessDtoFactory;
import com.appdynamics.agent.sim.docker.model.ImagePropertiesDto;
import com.appdynamics.sim.agent.extensions.api.client.ExtensionRestServicesModule;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataModule;
import com.appdynamics.sim.agent.extensions.docker.ContainerPropertiesRegistry;
import com.appdynamics.sim.agent.extensions.docker.DockerCollector;
import com.appdynamics.sim.agent.extensions.docker.DockerMonitor;
import com.appdynamics.sim.agent.extensions.docker.DockerMonitorConfigListener;
import com.appdynamics.sim.agent.extensions.docker.DockerMonitoring;
import com.appdynamics.sim.agent.extensions.docker.DockerProcessMonitor;
import com.appdynamics.sim.agent.extensions.docker.DockerProcessProperties;
import com.appdynamics.sim.agent.extensions.docker.DockerRegistrationTaskFactory;
import com.appdynamics.sim.agent.extensions.docker.DoubleBufferedDockerProcessProperties;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitoringBootstrapConfig;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitoringBootstrapConfigModule;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitoringBootstrapConfigProvider;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.CGroupMetricsCollectorModule;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFilePathDictionary;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFilePathResolver;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileReader;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileSystemPath;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileSystemRootProvider;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupNetworkCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.DockerApiMetricsCollectorModule;
import com.appdynamics.sim.agent.extensions.docker.properties.DockerContainerPropertiesFactory;
import com.appdynamics.sim.agent.extensions.docker.properties.dockerApi.model.DockerApiContainerProperties;
import com.appdynamics.sim.agent.extensions.docker.properties.model.ContainerProperties;
import com.appdynamics.sim.agent.extensions.docker.tags.DockerTagsConfigsDecider;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.appdynamics.sim.processes.agent.rest.SimProcessesAgentService;
import com.appdynamics.voltron.configuration.ConfigurationClientModule;
import com.appdynamics.voltron.extensions.api.ExtensionModule;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtensionModule
public class DockerMonitoringModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerMonitoringModule.class);
    private static final long EXPIRY_TIME_IN_MINUTES = 10L;
    private static final String DOCKER_METRIC_COLLECTOR_THREAD_NAME = "Docker-Monitoring-%d";
    private static final boolean DEFAULT_CONTAINER_COLLECTION_CGROUP = false;

    protected void configure() {
        this.install((Module)new DockerMonRestApis());
        this.bind(DockerMonitor.class).asEagerSingleton();
        this.bind(DockerCollector.class).in(Scopes.SINGLETON);
        this.bind(IContainerProcessDtoFactory.class).to(ContainerProcessDtoFactory.class).in(Scopes.SINGLETON);
        this.bind(DockerContainerFull.class);
        this.bind(ContainerPropertiesRegistry.class).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<Optional<String>>(){}).annotatedWith(CGroupFileSystemPath.class).toProvider(CGroupFileSystemRootProvider.class).in(Scopes.SINGLETON);
        this.bind(CGroupFileReader.class).in(Scopes.SINGLETON);
        this.bind(CGroupFilePathDictionary.class).in(Scopes.SINGLETON);
        this.bind(CGroupFilePathResolver.class).in(Scopes.SINGLETON);
        this.bind(CGroupNetworkCollector.class).in(Scopes.SINGLETON);
        this.install((Module)new DockerMonitoringBootstrapConfigModule());
        boolean cgroupCollectionEnabled = SystemUtilsTranslateable.getBooleanProperty((String)"appdynamics.docker.container.collection.cgroup.enabled", (boolean)false);
        this.install((Module)new RawDataModule());
        this.bind(DockerProcessMonitor.class).asEagerSingleton();
        if (cgroupCollectionEnabled) {
            this.install((Module)new CGroupMetricsCollectorModule());
        } else {
            this.install((Module)new DockerApiMetricsCollectorModule());
        }
        this.install((Module)new ConfigurationClientModule(){

            protected void configureListenersAndValidators() {
                this.bindInjectableConfig("DockerMonitoring", DockerMonitorConfig.class, new DockerMonitorConfig(), true);
                this.bindInjectableConfig("_agentMonitoringConfig", AgentMonitorConfig.class, new AgentMonitorConfig(), true);
                this.bindConfigListener("DockerMonitoring", DockerMonitorConfig.class).to(DockerMonitorConfigListener.class);
                this.bind(DockerProcessProperties.class).to(DoubleBufferedDockerProcessProperties.class).in(Scopes.SINGLETON);
            }
        });
        this.install(new FactoryModuleBuilder().implement(ContainerProperties.class, DockerApiContainerProperties.class).build(DockerContainerPropertiesFactory.class));
        this.install(new FactoryModuleBuilder().build(DockerRegistrationTaskFactory.class));
        this.bind(DockerTagsConfigsDecider.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    @DockerMonitoring
    ExecutorService providesDockerMonitoringExecutorService(DockerMonitoringBootstrapConfigProvider configProvider) {
        DockerMonitoringBootstrapConfig dockerMonitoringBootstrapConfig = configProvider.get();
        Integer poolSize = dockerMonitoringBootstrapConfig.getContainerFetchPoolSize();
        log.info("Initializing Executor Service for Docker Metric Collection, pool size:  {}", (Object)poolSize);
        ThreadFactory collectorThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(DOCKER_METRIC_COLLECTOR_THREAD_NAME).build();
        return Executors.newFixedThreadPool(poolSize, collectorThreadFactory);
    }

    @Provides
    @Singleton
    Cache<String, ImagePropertiesDto> getDockerContainerImagesCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    }

    private static class DockerMonRestApis
    extends ExtensionRestServicesModule {
        private DockerMonRestApis() {
        }

        protected void configureServices() {
            this.serve(SimProcessesAgentService.class).fromPath("/sim");
        }
    }
}

