/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.docker.DockerEngineAccessibilitySupplier;
import com.appdynamics.agent.sim.docker.DockerService;
import com.appdynamics.agent.sim.docker.DockerUtils;
import com.appdynamics.agent.sim.docker.model.ContainerDto;
import com.appdynamics.agent.sim.docker.model.ContainerPropertiesDto;
import com.appdynamics.agent.sim.docker.model.DockerContainerFull;
import com.appdynamics.agent.sim.lightagent.LightAgentRegistry;
import com.appdynamics.agent.sim.lightagent.LightSystemAgent;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.agent.sim.main.MachineAgentEnabledFeatures;
import com.appdynamics.agent.sim.metadata.MachineMetadata;
import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.docker.ContainerHostMapper;
import com.appdynamics.sim.agent.extensions.docker.ContainerPropertiesRegistry;
import com.appdynamics.sim.agent.extensions.docker.DockerCollector;
import com.appdynamics.sim.agent.extensions.docker.DockerMonitoring;
import com.appdynamics.sim.agent.extensions.docker.DockerRegistrationTask;
import com.appdynamics.sim.agent.extensions.docker.DockerRegistrationTaskFactory;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitoringBootstrapConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.ContainerMetricsCollectionManager;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.docker.properties.DockerContainerPropertiesFactory;
import com.appdynamics.sim.agent.extensions.docker.properties.model.ContainerProperties;
import com.appdynamics.sim.common.biz.shared.docker.AgentMetadataDockerRequest;
import com.appdynamics.sim.common.biz.shared.docker.ContainerMappingInfo;
import com.appdynamics.voltron.utils.TimeSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DockerMonitor
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerMonitor.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final boolean HISTORICAL = true;
    private static final long REGISTRATION_TIMEOUT_IN_SECONDS = 60L;
    private final Scheduler scheduler;
    private final DockerCollector dockerCollector;
    private final ContainerHostMapper containerHostMapper;
    private final ContainerMetricsCollectionManager<?> containerMetricsCollectionManager;
    private final Provider<DockerMonitorConfig> dockerMonitorConfig;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final DockerContainerPropertiesFactory dockerContainerPropertiesFactory;
    private final LightAgentRegistry lightAgentRegistry;
    private final MachineMetadata machineMetadata;
    private final DockerMonitoringBootstrapConfig dockerMonitoringBootstrapConfig;
    private final TimeSupplier timeSupplier;
    private final DockerRegistrationTaskFactory registrationTaskFactory;
    private final ExecutorService dockerMonitoringExecutorService;
    private final ContainerPropertiesRegistry containerPropertiesRegistry;
    private final String serverHostId;
    private final Supplier<DockerService> dockerServiceSupplier;
    private final DockerEngineAccessibilitySupplier dockerEngineAccessibilitySupplier;
    private final MachineAgentEnabledFeatures machineAgentEnabledFeatures;
    private Map<String, ContainerProperties> containerPropertiesMap;
    private Map<String, DockerContainerFull> currentContainerIdVsContainer;
    private volatile ScheduledFuture<?> future;
    private volatile long scheduledInterval;
    private volatile boolean iblSupported;
    private static final Set<ContainerComponentName> ALL_COMPONENTS = ImmutableSet.of((Object)((Object)ContainerComponentName.CPUS), (Object)((Object)ContainerComponentName.PROCESS), (Object)((Object)ContainerComponentName.MEMORY), (Object)((Object)ContainerComponentName.DISK), (Object)((Object)ContainerComponentName.NETWORK));

    @Inject
    DockerMonitor(Scheduler scheduler, MachineMetadata machineMetadata, DockerCollector dockerCollector, ContainerHostMapper containerHostMapper, ContainerMetricsCollectionManager<?> containerMetricsCollectionManager, DockerContainerPropertiesFactory dockerContainerPropertiesFactory, BootstrapConfiguration bootstrapConfiguration, Provider<DockerMonitorConfig> dockerMonitorConfig, SimAgentRepetitiveLogger repetitiveLogger, LightAgentRegistry lightAgentRegistry, DockerMonitoringBootstrapConfig dockerMonitoringBootstrapConfig, TimeSupplier timeSupplier, DockerRegistrationTaskFactory registrationTaskFactory, ContainerPropertiesRegistry containerPropertiesRegistry, @DockerMonitoring ExecutorService executorService, @HostId String serverHostId, Supplier<DockerService> dockerServiceSupplier, DockerEngineAccessibilitySupplier dockerEngineAccessibilitySupplier, MachineAgentEnabledFeatures machineAgentEnabledFeatures) {
        this.scheduler = scheduler;
        this.dockerCollector = dockerCollector;
        this.containerHostMapper = containerHostMapper;
        this.containerMetricsCollectionManager = containerMetricsCollectionManager;
        this.dockerContainerPropertiesFactory = dockerContainerPropertiesFactory;
        this.dockerMonitorConfig = dockerMonitorConfig;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.repetitiveLogger = repetitiveLogger;
        this.containerPropertiesMap = Collections.emptyMap();
        this.currentContainerIdVsContainer = Collections.emptyMap();
        this.lightAgentRegistry = lightAgentRegistry;
        this.machineMetadata = machineMetadata;
        this.dockerMonitoringBootstrapConfig = dockerMonitoringBootstrapConfig;
        this.timeSupplier = timeSupplier;
        this.registrationTaskFactory = registrationTaskFactory;
        this.containerPropertiesRegistry = containerPropertiesRegistry;
        this.dockerMonitoringExecutorService = executorService;
        this.serverHostId = serverHostId;
        this.dockerServiceSupplier = dockerServiceSupplier;
        this.dockerEngineAccessibilitySupplier = dockerEngineAccessibilitySupplier;
        this.machineAgentEnabledFeatures = machineAgentEnabledFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void startMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            boolean dockerEnabled = this.bootstrapConfiguration.getDockerEnabled();
            boolean containerdEnabled = this.bootstrapConfiguration.getContainerdEnabled();
            boolean simEnabled = this.bootstrapConfiguration.getSimUserEnabled();
            if (this.isDockerMonitoringSupportedOnCurrentOS()) {
                if (this.future == null) {
                    if (dockerEnabled && containerdEnabled) {
                        log.error("Both Docker and Containerd enabled. Please enable only one of them");
                        log.info("Not starting docker monitoring extension because both docker and containerd are enabled");
                        return;
                    }
                    if (this.runDockerMonitoring()) {
                        log.debug("Scheduling docker monitor");
                        this.scheduledInterval = ((DockerMonitorConfig)this.dockerMonitorConfig.get()).getSamplingInterval();
                        this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, this.scheduledInterval, TimeUnit.MILLISECONDS);
                    } else {
                        log.info("Not starting docker monitoring extension");
                        log.info("Docker Enabled: {}; SIM Enabled: {}; MA Plus available: {}", new Object[]{dockerEnabled, simEnabled, this.iblSupported});
                    }
                }
            } else {
                log.info("Docker monitoring is not supported on current OS: {}. Running Machine Agent with Docker disabled", (Object)SystemUtils.OS_NAME);
            }
        }
    }

    boolean runDockerMonitoring() {
        boolean dockerEnabled = this.bootstrapConfiguration.getDockerEnabled();
        boolean simEnabled = this.bootstrapConfiguration.getSimUserEnabled();
        this.iblSupported = this.isIblSupported();
        return this.iblSupported || dockerEnabled && simEnabled;
    }

    @VisibleForTesting
    boolean isIblSupported() {
        boolean iblStatusCheck = ((DockerMonitorConfig)this.dockerMonitorConfig.get()).getContainerMapperConfig().getEnabled();
        if (iblStatusCheck) {
            iblStatusCheck = this.isIblEnabled();
            log.debug("IBL feature available: {}", (Object)iblStatusCheck);
            iblStatusCheck &= this.dockerEngineAccessibilitySupplier.get().booleanValue();
        } else {
            log.warn("Container mapper flow is disabled");
        }
        return iblStatusCheck;
    }

    @VisibleForTesting
    boolean isDockerMonitoringSupportedOnCurrentOS() {
        return DockerUtils.isDockerMonitoringSupportedOnCurrentOS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stopMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                log.debug("Canceling docker monitor");
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    @Override
    public void run() {
        try {
            long start = this.timeSupplier.get();
            log.debug("Running docker monitoring");
            DockerService dockerService = (DockerService)this.dockerServiceSupplier.get();
            List containers = dockerService.getContainers();
            if (this.bootstrapConfiguration.getSimUserEnabled().booleanValue() && this.isSimEnabled() && this.bootstrapConfiguration.getDockerEnabled().booleanValue()) {
                log.debug("Running SIM docker monitoring");
                this.runSimDockerMonitoring(containers, dockerService);
            }
            if (this.getLastIblSupportedValue()) {
                log.debug("Running MA Plus docker monitoring");
                this.runMaPlusDockerMonitoring(containers, dockerService);
            }
            if (this.isMonitorRestartRequired()) {
                this.stopMonitor();
                this.startMonitor();
            }
            long end = this.timeSupplier.get();
            log.debug("#Total time to execute Docker Monitoring: {} ms", (Object)(end - start));
        }
        catch (Exception e) {
            log.error("Error running the docker monitoring: " + e.getMessage());
        }
    }

    @VisibleForTesting
    void runSimDockerMonitoring(List<ContainerDto> containers, DockerService dockerService) {
        Map<String, DockerContainerFull> containerIdToContainerMap = this.dockerCollector.collect(containers, dockerService);
        this.checkForDuplicateHostIds(containerIdToContainerMap);
        Set nonApmContainers = this.lightAgentRegistry.getNonApmContainersToBeMarkedHistorical();
        containerIdToContainerMap = this.removeKeys(containerIdToContainerMap, nonApmContainers);
        Set<String> containerIds = containerIdToContainerMap.keySet();
        log.debug("registerContainers");
        this.registerContainers(containerIdToContainerMap);
        HashSet<String> containersToRemove = new HashSet<String>();
        containersToRemove.addAll(this.lightAgentRegistry.getNonRunningContainers(containerIds));
        containersToRemove.addAll(nonApmContainers);
        if (!containersToRemove.isEmpty()) {
            this.markContainersHistorical(containersToRemove);
            this.lightAgentRegistry.removeNonRunningContainers(containersToRemove);
            this.containerPropertiesMap = this.removeKeys(this.containerPropertiesMap, containersToRemove);
        }
        this.containerPropertiesMap = this.buildContainerPropertiesMap(containerIds);
        this.currentContainerIdVsContainer = containerIdToContainerMap;
        this.updateContainerPropertiesRegistry(containerIdToContainerMap);
        AgentMetadataDockerRequest agentMetadataDockerRequest = this.buildAgentMetadataDockerRequest(containerIdToContainerMap);
        this.machineMetadata.updateMetadata("_agentMetadataDocker", (Object)agentMetadataDockerRequest);
        log.debug("Reporting Docker Containers.");
        this.dockerCollector.reportProperties(this.containerPropertiesMap);
        HashMap<String, DockerContainerFull> containerIdToContainerDtoMap = new HashMap<String, DockerContainerFull>();
        Set lightAgentRunningContainerIds = this.lightAgentRegistry.getAllRunningContainerIds();
        for (String containerId : containerIdToContainerMap.keySet()) {
            if (!lightAgentRunningContainerIds.contains(containerId)) continue;
            containerIdToContainerDtoMap.put(containerId, containerIdToContainerMap.get(containerId));
        }
        this.containerMetricsCollectionManager.collectAndReport(containerIdToContainerDtoMap, ALL_COMPONENTS);
    }

    @VisibleForTesting
    void runMaPlusDockerMonitoring(List<ContainerDto> containers, DockerService dockerService) {
        this.containerHostMapper.updateContainerHostMappings(containers, dockerService);
    }

    @VisibleForTesting
    void checkForDuplicateHostIds(Map<String, DockerContainerFull> containerIdToContainer) {
        Map<String, String> containerIdToHostId = containerIdToContainer.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((DockerContainerFull)e.getValue()).getHostId()));
        Set<Map.Entry> duplicateContainerDtosByHostId = containerIdToContainer.values().stream().collect(Collectors.groupingBy(e -> e.getHostId())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toSet());
        if (!duplicateContainerDtosByHostId.isEmpty()) {
            duplicateContainerDtosByHostId.forEach(e -> this.repetitiveLogger.warn(log, "Host Id {} is used by container Ids {}", new Object[]{e.getKey(), ((List)e.getValue()).stream().map(v -> v.getId()).collect(Collectors.toSet())}));
        }
        if (containerIdToHostId.values().contains(this.serverHostId)) {
            Set containerIdsMatchingHostServerHostId = containerIdToHostId.entrySet().stream().filter(e -> ((String)e.getValue()).equals(this.serverHostId)).map(Map.Entry::getKey).collect(Collectors.toSet());
            this.repetitiveLogger.warn(log, "Container Ids: {} are using the host Id: {} that is same as host server's host Id", new Object[]{containerIdsMatchingHostServerHostId, this.serverHostId});
        }
    }

    @VisibleForTesting
    void registerContainers(Map<String, DockerContainerFull> containerIdVsContainer) {
        long startTime = this.timeSupplier.get();
        ArrayList<DockerRegistrationTask> dockerRegistrationTasks = new ArrayList<DockerRegistrationTask>(containerIdVsContainer.size());
        for (String containerId : containerIdVsContainer.keySet()) {
            try {
                DockerContainerFull dockerContainerFull = containerIdVsContainer.get(containerId);
                Optional lightSystemAgentOpt = this.lightAgentRegistry.getAgent(containerId);
                if (lightSystemAgentOpt.isPresent() && !this.isContainerRegistrationDue((LightSystemAgent)lightSystemAgentOpt.get())) continue;
                DockerRegistrationTask dockerRegistrationTask = this.registrationTaskFactory.create(dockerContainerFull, false);
                log.trace("Creating registration task for container " + dockerContainerFull.getId());
                dockerRegistrationTasks.add(dockerRegistrationTask);
            }
            catch (RuntimeException re) {
                this.repetitiveLogger.warn(log, "Error creating registration task for container: {} ", new Object[]{containerId});
            }
        }
        this.submitContainerRegistrations(dockerRegistrationTasks);
        long endTime = this.timeSupplier.get();
        log.trace("#Total time for Container Registration: {} ms.", (Object)(endTime - startTime));
    }

    void submitContainerRegistrations(List<DockerRegistrationTask> registrationTasks) {
        try {
            List dockerRegistrationFutures = this.dockerMonitoringExecutorService.invokeAll(registrationTasks);
            for (Future dockerRegistrationFuture : dockerRegistrationFutures) {
                try {
                    dockerRegistrationFuture.get(60L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    log.warn("Unable to retrieve docker registration result with cause: {}", (Object)e.getMessage());
                }
                catch (TimeoutException e) {
                    log.warn("A container registration timed out", (Object)e.getMessage());
                }
            }
        }
        catch (InterruptedException e) {
            log.warn("Docker Container Registration is interrupted");
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    void markContainersHistorical(Set<String> nonRunningContainerIds) {
        ArrayList<DockerRegistrationTask> dockerRegistrationTasks = new ArrayList<DockerRegistrationTask>(nonRunningContainerIds.size());
        for (String containerId : nonRunningContainerIds) {
            try {
                dockerRegistrationTasks.add(this.registrationTaskFactory.create(this.currentContainerIdVsContainer.get(containerId), true));
            }
            catch (RuntimeException e) {
                String message = MessageFormat.format("Error while creating registration task to mark container id {0} historical. {1}", containerId, e.getMessage());
                this.printWarnMessage(message);
            }
        }
        this.submitContainerRegistrations(dockerRegistrationTasks);
    }

    @VisibleForTesting
    boolean isContainerRegistrationDue(LightSystemAgent lightSystemAgent) {
        long now = this.timeSupplier.get();
        long diffTimeInMilliSeconds = now - lightSystemAgent.getLastRegisteredTime();
        long roundedDiffTimeInSeconds = Math.round(1.0 * (double)diffTimeInMilliSeconds / 1000.0);
        return roundedDiffTimeInSeconds >= (long)this.dockerMonitoringBootstrapConfig.getContainerRegistrationInterval().intValue();
    }

    private AgentMetadataDockerRequest buildAgentMetadataDockerRequest(Map<String, DockerContainerFull> containerIdToContainerMap) {
        ImmutableSet.Builder containerMappingInfoBuilder = ImmutableSet.builder();
        for (String containerId : this.lightAgentRegistry.getAllRunningContainerIds()) {
            DockerContainerFull dockerContainerFull = containerIdToContainerMap.get(containerId);
            Optional lightSystemAgentOptional = this.lightAgentRegistry.getAgent(containerId);
            if (lightSystemAgentOptional.isPresent()) {
                long containerSimMachineId = ((LightSystemAgent)lightSystemAgentOptional.get()).getSimMachineId();
                ContainerMappingInfo containerMappingInfo = ContainerMappingInfo.builder().containerId(dockerContainerFull.getId()).simMachineId(containerSimMachineId).hostName(dockerContainerFull.getHostId()).build();
                containerMappingInfoBuilder.add((Object)containerMappingInfo);
                continue;
            }
            this.repetitiveLogger.warn(log, "Failed to add container - {} to metadata, LightAgent not found in LightAgentRegistry.", new Object[]{containerId});
        }
        return new AgentMetadataDockerRequest((Set)containerMappingInfoBuilder.build());
    }

    @VisibleForTesting
    Map<String, ContainerProperties> buildContainerPropertiesMap(Set<String> containerIds) {
        ImmutableMap.Builder containerPropertiesMapBuilder = new ImmutableMap.Builder();
        for (String containerId : containerIds) {
            try {
                ContainerProperties containerProperties = this.containerPropertiesMap.get(containerId);
                if (containerProperties == null) {
                    Optional lightSystemAgentOptional = this.lightAgentRegistry.getAgent(containerId);
                    if (lightSystemAgentOptional.isPresent()) {
                        MachineProperties machineProperties = ((LightSystemAgent)this.lightAgentRegistry.getAgent(containerId).get()).getContainerProperties();
                        containerProperties = this.dockerContainerPropertiesFactory.make(machineProperties);
                        containerPropertiesMapBuilder.put((Object)containerId, (Object)containerProperties);
                        continue;
                    }
                    this.repetitiveLogger.debug(log, "LightAgent not found in LightAgentRegistry for container - {}", new Object[]{containerId});
                    continue;
                }
                containerPropertiesMapBuilder.put((Object)containerId, (Object)containerProperties);
            }
            catch (RuntimeException e) {
                this.repetitiveLogger.warn(log, "Failed to add container - {} to the DockerApiContainerProperties map.", new Object[]{containerId, e});
            }
        }
        return containerPropertiesMapBuilder.build();
    }

    @VisibleForTesting
    void updateContainerPropertiesRegistry(Map<String, DockerContainerFull> containerIdToContainerMap) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<String, DockerContainerFull> entry : containerIdToContainerMap.entrySet()) {
            map.put((Object)entry.getKey(), (Object)entry.getValue().getContainerPropertiesDto());
        }
        this.containerPropertiesRegistry.set((Map<String, ContainerPropertiesDto>)map.build());
    }

    @VisibleForTesting
    protected boolean isMonitorRestartRequired() {
        boolean simDockerMonitorChanged = this.scheduledInterval != ((DockerMonitorConfig)this.dockerMonitorConfig.get()).getSamplingInterval();
        log.debug("Sim Docker Monitor Changed: {}", (Object)simDockerMonitorChanged);
        boolean maPlusDockerMonitorChanged = this.iblSupported != this.isIblSupported();
        log.debug("MA Plus Docker Monitor Changed: {}", (Object)maPlusDockerMonitorChanged);
        return simDockerMonitorChanged || maPlusDockerMonitorChanged;
    }

    @VisibleForTesting
    void printWarnMessage(String message) {
        log.warn(message);
    }

    private <T> Map<String, T> removeKeys(Map<String, T> map, Set<String> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : map.keySet()) {
            if (keys.contains(key)) continue;
            builder.put((Object)key, map.get(key));
        }
        return builder.build();
    }

    @VisibleForTesting
    boolean isIblEnabled() {
        boolean result = this.machineAgentEnabledFeatures.hasFeature("ibl");
        log.trace("IBL feature enabled: {}", (Object)result);
        return result;
    }

    @VisibleForTesting
    boolean isSimEnabled() {
        boolean result = this.machineAgentEnabledFeatures.hasFeature("sim");
        log.trace("SIM feature enabled: {}", (Object)result);
        return result;
    }

    @VisibleForTesting
    boolean getLastIblSupportedValue() {
        log.trace("Last result of MA plus eligibility: {}", (Object)this.iblSupported);
        return this.iblSupported;
    }
}

