/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker;

import com.appdynamics.agent.sim.docker.DockerService;
import com.appdynamics.agent.sim.docker.model.ContainerDto;
import com.appdynamics.agent.sim.docker.model.ContainerProcess;
import com.appdynamics.agent.sim.docker.model.ContainerPropertiesDto;
import com.appdynamics.agent.sim.docker.model.DockerContainerFull;
import com.appdynamics.agent.sim.docker.model.IContainerProcessDtoFactory;
import com.appdynamics.agent.sim.docker.model.ImagePropertiesDto;
import com.appdynamics.agent.sim.k8s.K8sContainerTags;
import com.appdynamics.agent.sim.lightagent.LightAgentRegistry;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitoringBootstrapConfig;
import com.appdynamics.sim.agent.extensions.docker.properties.model.ContainerProperties;
import com.appdynamics.sim.common.biz.shared.docker.DockerContainerUtils;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.appdynamics.voltron.utils.TimeSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerCollector.class);
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final Provider<DockerMonitorConfig> dockerMonitorConfigProvider;
    private final DockerMonitoringBootstrapConfig dockerMonitoringBootstrapConfig;
    private IContainerProcessDtoFactory containerProcessDtoFactory;
    private Map<String, ContainerPropertiesDto> containerPropertiesRawDataMap;
    private Map<String, Optional<ImagePropertiesDto>> containerImageRawDataMap;
    private final LightAgentRegistry lightAgentRegistry;
    private final TimeSupplier timeSupplier;
    private final Cache<String, ImagePropertiesDto> imagePropertiesCache;
    private Provider<AgentMonitorConfig> agentMonitorConfigProvider;
    private final K8sContainerTags k8sContainerTags;
    private static final Integer DEFAULT_CONTAINER_LIMIT = 100;
    private static final String NETWORK_MODE_HOST = "host";

    @Inject
    DockerCollector(SimAgentRepetitiveLogger repetitiveLogger, IContainerProcessDtoFactory containerProcessDtoFactory, Provider<DockerMonitorConfig> dockerMonitorConfigProvider, Cache<String, ImagePropertiesDto> imagePropertiesCache, Provider<AgentMonitorConfig> agentMonitorConfigProvider, LightAgentRegistry lightAgentRegistry, DockerMonitoringBootstrapConfig dockerMonitoringBootstrapConfig, TimeSupplier timeSupplier, K8sContainerTags k8sContainerTags) {
        this.repetitiveLogger = repetitiveLogger;
        this.containerProcessDtoFactory = containerProcessDtoFactory;
        this.dockerMonitorConfigProvider = dockerMonitorConfigProvider;
        this.containerPropertiesRawDataMap = Collections.emptyMap();
        this.imagePropertiesCache = imagePropertiesCache;
        this.agentMonitorConfigProvider = agentMonitorConfigProvider;
        this.lightAgentRegistry = lightAgentRegistry;
        this.dockerMonitoringBootstrapConfig = dockerMonitoringBootstrapConfig;
        this.timeSupplier = timeSupplier;
        this.k8sContainerTags = k8sContainerTags;
    }

    public Map<String, DockerContainerFull> collect(List<ContainerDto> containers, DockerService dockerService) {
        Optional<Pattern> blacklistSelectorPattern;
        Pattern selectorPattern;
        long startTime = this.timeSupplier.get();
        if (this.dockerMonitoringBootstrapConfig.getUseContainerNameSelector().booleanValue()) {
            selectorPattern = this.getNameSelectorPattern();
            blacklistSelectorPattern = this.getNameBlacklistSelectorPattern();
        } else {
            selectorPattern = this.getProcessSelectorPattern();
            blacklistSelectorPattern = this.getProcessBlacklistSelectorPattern();
        }
        log.debug("filterContainersWithPattern");
        Set<String> containerIdsForMatchedContainers = this.filterContainersWithPattern(containers, this.dockerMonitoringBootstrapConfig.getUseContainerNameSelector(), selectorPattern, blacklistSelectorPattern, dockerService);
        log.debug("collectContainerProperties");
        this.containerPropertiesRawDataMap = this.collectContainerProperties(containerIdsForMatchedContainers, dockerService);
        Set<String> validContainerIds = this.filterValidContainers(containerIdsForMatchedContainers);
        Set<String> validLimitFilteredContainerIds = this.filterContainersByLimit(validContainerIds);
        log.debug("collectContainerImages");
        this.containerImageRawDataMap = this.collectContainerImages(validLimitFilteredContainerIds, dockerService);
        this.k8sContainerTags.updateContainers(validLimitFilteredContainerIds);
        Map<String, DockerContainerFull> containerIdToContainerMap = this.buildDockerContainerDtos(validLimitFilteredContainerIds);
        Set<String> containerIds = containerIdToContainerMap.keySet();
        log.debug("{} containers being monitored: {}", (Object)containerIds.size(), containerIds);
        long endTime = this.timeSupplier.get();
        log.trace("#Total time for Docker Metric Collection: {} ms", (Object)(endTime - startTime));
        return containerIdToContainerMap;
    }

    public void reportProperties(@NonNull Map<String, ContainerProperties> containerPropertiesMap) {
        if (containerPropertiesMap == null) {
            throw new NullPointerException("containerPropertiesMap is marked non-null but is null");
        }
        Set<String> containerIds = containerPropertiesMap.keySet();
        for (String containerId : containerIds) {
            ContainerProperties containerProperties = containerPropertiesMap.get(containerId);
            try {
                ContainerPropertiesDto containerPropertiesDto = this.containerPropertiesRawDataMap.get(containerId);
                if (containerPropertiesDto == null) {
                    log.trace("Could not get ContainerPropertiesDto for the container {}. So skipping update and reportProperties.", (Object)containerId);
                    continue;
                }
                containerProperties.update(containerPropertiesDto);
                containerProperties.report();
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Exception while trying to update and reportProperties container metrics for the container {} ", new Object[]{containerId, e});
            }
        }
    }

    private Set<String> filterValidContainers(Set<String> containerIds) {
        ImmutableSet.Builder validContainerIds = ImmutableSet.builder();
        for (String containerId : containerIds) {
            try {
                ContainerPropertiesDto containerProperties = this.containerPropertiesRawDataMap.get(containerId);
                boolean isValid = this.isHostNameValid(containerProperties);
                if (isValid) {
                    validContainerIds.add((Object)containerId);
                    continue;
                }
                this.repetitiveLogger.warn(log, "Skipping container {} due to invalid Hostname.", new Object[]{containerId});
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Exception while trying to filter container {} ", new Object[]{containerId, e});
            }
        }
        return validContainerIds.build();
    }

    private boolean isHostNameValid(ContainerPropertiesDto containerPropertiesDto) {
        ContainerPropertiesDto.Config config = containerPropertiesDto.getConfig();
        String hostName = config.getHostName();
        boolean isValid = !StringUtils.isEmpty((CharSequence)hostName);
        return isValid;
    }

    private Map<String, DockerContainerFull> buildDockerContainerDtos(Set<String> containerIds) {
        ImmutableMap.Builder containers = ImmutableMap.builder();
        for (String containerId : containerIds) {
            try {
                ContainerPropertiesDto containerPropertiesDto = this.containerPropertiesRawDataMap.get(containerId);
                Optional<ImagePropertiesDto> imagePropertiesDto = this.containerImageRawDataMap.get(containerId);
                Map containerTags = this.k8sContainerTags.getTagsByContainerId(containerId);
                ContainerPropertiesDto.Config config = containerPropertiesDto.getConfig();
                String hostId = this.getEffectiveHostId(containerPropertiesDto, containerId);
                DockerContainerFull dockerContainerFull = new DockerContainerFull(containerId, config.getHostName(), hostId, containerPropertiesDto, imagePropertiesDto, containerTags);
                containers.put((Object)containerId, (Object)dockerContainerFull);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Exception while trying to build container Dto {} ", new Object[]{containerId, e});
            }
        }
        return containers.build();
    }

    @VisibleForTesting
    Set<String> filterContainersWithPattern(List<ContainerDto> containers, boolean useContainerNameSelector, Pattern includePattern, Optional<Pattern> excludePattern, DockerService dockerService) {
        ImmutableSet.Builder containersWithFlag = ImmutableSet.builder();
        log.trace("All running containers on this host: {}", containers);
        for (ContainerDto container : containers) {
            Optional<Pattern> machineAgentPattern;
            List processes;
            String containerId = container.getId();
            if (useContainerNameSelector) {
                if (container.getNames() == null) continue;
                boolean includeContainer = false;
                for (String name : container.getNames()) {
                    Optional<Pattern> machineAgentPattern2;
                    if (this.dockerMonitoringBootstrapConfig.getUseMonitorMachineAgentContainer().booleanValue() && (machineAgentPattern2 = this.getMachineAgentContainerPattern()).isPresent() && ((Pattern)machineAgentPattern2.get()).matcher(name).matches()) {
                        log.trace("Adding container to monitoring- {}", (Object)containerId);
                        includeContainer = true;
                        break;
                    }
                    if (excludePattern.isPresent() && ((Pattern)excludePattern.get()).matcher(name).matches()) {
                        log.trace("Exclude container's name: {}", (Object)name);
                        break;
                    }
                    if (!includePattern.matcher(name).matches()) continue;
                    log.trace("Include container's name: {}", (Object)name);
                    includeContainer = true;
                    break;
                }
                if (!includeContainer) continue;
                containersWithFlag.add((Object)containerId);
                continue;
            }
            try {
                processes = this.containerProcessDtoFactory.convertToContainerProcesses(dockerService.getProcessesForContainer(containerId));
            }
            catch (RuntimeException e) {
                this.repetitiveLogger.warn(log, "The docker service did not find processes for container with id {}", new Object[]{containerId});
                continue;
            }
            if (this.dockerMonitoringBootstrapConfig.getUseMonitorMachineAgentContainer().booleanValue() && (machineAgentPattern = this.getMachineAgentProcessPattern()).isPresent() && this.isProcessesMatchPattern(processes, (Pattern)machineAgentPattern.get())) {
                log.trace("Adding container to monitoring- {}", (Object)containerId);
                containersWithFlag.add((Object)containerId);
                continue;
            }
            if (excludePattern.isPresent() && this.isProcessesMatchPattern(processes, (Pattern)excludePattern.get())) {
                log.trace("Excluding container from monitoring- {}", (Object)containerId);
                continue;
            }
            if (!this.isProcessesMatchPattern(processes, includePattern)) continue;
            containersWithFlag.add((Object)containerId);
        }
        return containersWithFlag.build();
    }

    @VisibleForTesting
    Set<String> filterContainersByLimit(Set<String> collectedContainerIds) {
        int limit = this.getContainersLimit();
        if (collectedContainerIds.size() <= limit) {
            return collectedContainerIds;
        }
        Set existingContainerIds = this.lightAgentRegistry.getAllRunningContainerIds();
        HashSet retainedContainerIdsSet = Sets.newHashSet(collectedContainerIds);
        retainedContainerIdsSet.retainAll(existingContainerIds);
        if (retainedContainerIdsSet.size() == limit) {
            return ImmutableSet.copyOf((Collection)retainedContainerIdsSet);
        }
        if (retainedContainerIdsSet.size() > limit) {
            return ImmutableSet.copyOf(Lists.newLinkedList((Iterable)retainedContainerIdsSet).subList(0, limit));
        }
        Sets.SetView onlyNewContainerIdsSet = Sets.difference(collectedContainerIds, (Set)retainedContainerIdsSet);
        for (String newContainerid : onlyNewContainerIdsSet) {
            if (retainedContainerIdsSet.size() >= limit) break;
            retainedContainerIdsSet.add(newContainerid);
        }
        return ImmutableSet.copyOf((Collection)retainedContainerIdsSet);
    }

    @VisibleForTesting
    Map<String, ContainerPropertiesDto> collectContainerProperties(Set<String> containerIds, DockerService dockerService) {
        ImmutableMap.Builder containerPropertiesDtoMap = new ImmutableMap.Builder();
        for (String containerId : containerIds) {
            try {
                ContainerPropertiesDto containerPropertiesDto = dockerService.getContainerProperties(containerId);
                containerPropertiesDtoMap.put((Object)containerId, (Object)containerPropertiesDto);
            }
            catch (RuntimeException e) {
                this.repetitiveLogger.warn(log, "The docker service did not find properties for container with id {}", new Object[]{containerId, e});
            }
        }
        return containerPropertiesDtoMap.build();
    }

    @VisibleForTesting
    Map<String, Optional<ImagePropertiesDto>> collectContainerImages(Set<String> containerIds, DockerService dockerService) {
        ImmutableMap.Builder containerImageDtoMap = new ImmutableMap.Builder();
        for (String containerId : containerIds) {
            Optional<ContainerPropertiesDto> propertiesDtoOptional = this.getContainerProperties(containerId);
            if (propertiesDtoOptional.isPresent()) {
                String imageName = ((ContainerPropertiesDto)propertiesDtoOptional.get()).getConfig().getImageName();
                Optional<ImagePropertiesDto> imagePropertiesDtoOptional = Optional.fromNullable((Object)((ImagePropertiesDto)this.imagePropertiesCache.getIfPresent((Object)imageName)));
                if (!imagePropertiesDtoOptional.isPresent() && (imagePropertiesDtoOptional = this.collectImageProperties(imageName, dockerService)).isPresent()) {
                    this.imagePropertiesCache.put((Object)imageName, (Object)((ImagePropertiesDto)imagePropertiesDtoOptional.get()));
                }
                containerImageDtoMap.put((Object)containerId, (Object)imagePropertiesDtoOptional);
                continue;
            }
            containerImageDtoMap.put((Object)containerId, (Object)Optional.absent());
        }
        return containerImageDtoMap.build();
    }

    @VisibleForTesting
    Optional<ImagePropertiesDto> collectImageProperties(String imageName, DockerService dockerService) {
        Optional containerImageDto = Optional.absent();
        try {
            containerImageDto = Optional.fromNullable((Object)dockerService.getImageProperties(imageName));
        }
        catch (RuntimeException e) {
            this.repetitiveLogger.warn(log, "The docker service did not find properties for image with name {}", new Object[]{imageName, e});
        }
        return containerImageDto;
    }

    @VisibleForTesting
    boolean isProcessesMatchPattern(List<ContainerProcess> processes, Pattern processPattern) {
        for (ContainerProcess process : processes) {
            String command = process.getCommandLine();
            if (command == null || !processPattern.matcher(command).matches()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    Pattern getProcessSelectorPattern() {
        String processSelectorRegex = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getContainerMonitoringConfig().getContainerProcessSelectorRegex();
        log.debug("Containers will be filtered based on this flag: {}", (Object)processSelectorRegex);
        return Pattern.compile(processSelectorRegex);
    }

    @VisibleForTesting
    Pattern getNameSelectorPattern() {
        String selectorRegex = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getContainerMonitoringConfig().getContainerNameSelectorRegex();
        log.debug("Container's name will be filtered based on this flag: {}", (Object)selectorRegex);
        return Pattern.compile(selectorRegex);
    }

    @VisibleForTesting
    Optional<Pattern> getProcessBlacklistSelectorPattern() {
        String processBlacklistSelectorRegex = this.dockerMonitoringBootstrapConfig.getContainerProcessSelectorBlacklistRegex();
        if (Strings.nullToEmpty((String)processBlacklistSelectorRegex).trim().isEmpty()) {
            return Optional.absent();
        }
        log.debug("Containers will be excluded based on this blacklist selector  regex: {}", (Object)processBlacklistSelectorRegex);
        return Optional.fromNullable((Object)Pattern.compile(processBlacklistSelectorRegex));
    }

    @VisibleForTesting
    Optional<Pattern> getNameBlacklistSelectorPattern() {
        String blacklistSelectorRegex = this.dockerMonitoringBootstrapConfig.getContainerNameSelectorBlacklistRegex();
        if (Strings.nullToEmpty((String)blacklistSelectorRegex).trim().isEmpty()) {
            return Optional.absent();
        }
        log.debug("Containers' names will be excluded based on this blacklist selector regex: {}", (Object)blacklistSelectorRegex);
        return Optional.fromNullable((Object)Pattern.compile(blacklistSelectorRegex));
    }

    @VisibleForTesting
    Optional<Pattern> getMachineAgentProcessPattern() {
        String machineAgentSelectorRegex = ".*machineagent\\.jar.*";
        if (Strings.nullToEmpty((String)machineAgentSelectorRegex).trim().isEmpty()) {
            return Optional.absent();
        }
        log.debug("Machine agent Process selector regex: {}", (Object)machineAgentSelectorRegex);
        return Optional.fromNullable((Object)Pattern.compile(machineAgentSelectorRegex));
    }

    @VisibleForTesting
    Optional<Pattern> getMachineAgentContainerPattern() {
        String machineAgentSelectorRegex = ".*(machine-agent|machineagent).*";
        if (Strings.nullToEmpty((String)machineAgentSelectorRegex).trim().isEmpty()) {
            return Optional.absent();
        }
        log.debug("Machine agent Containers selector regex: {}", (Object)machineAgentSelectorRegex);
        return Optional.fromNullable((Object)Pattern.compile(machineAgentSelectorRegex));
    }

    @VisibleForTesting
    Integer getContainersLimit() {
        Optional limitOptional = ((AgentMonitorConfig)this.agentMonitorConfigProvider.get()).getContainersLimit();
        if (limitOptional.isPresent()) {
            return (Integer)limitOptional.get();
        }
        return DEFAULT_CONTAINER_LIMIT;
    }

    @VisibleForTesting
    Optional<ContainerPropertiesDto> getContainerProperties(String containerId) {
        return Optional.fromNullable((Object)this.containerPropertiesRawDataMap.get(containerId));
    }

    private String getEffectiveHostId(ContainerPropertiesDto containerPropertiesDto, String containerId) {
        ContainerPropertiesDto.Config config = containerPropertiesDto.getConfig();
        String hostName = config.getHostName();
        ContainerPropertiesDto.HostConfig hostConfig = containerPropertiesDto.getHostConfig();
        String networkMode = hostConfig.getNetworkMode();
        if (this.shouldForceContainerIdAsHostId(networkMode)) {
            log.info("Container {} will use Container ID as Host ID", (Object)containerId);
            return DockerContainerUtils.getTruncatedId((String)containerId);
        }
        return hostName;
    }

    private boolean shouldForceContainerIdAsHostId(String networkMode) {
        if (this.dockerMonitoringBootstrapConfig.getUseContainerIdAsHostId().booleanValue()) {
            this.printReasonForForcingContainerIdAsHostId("\"appdynamics.docker.container.containerIdAsHostId.enabled\" is true");
            return true;
        }
        if (NETWORK_MODE_HOST.equalsIgnoreCase(networkMode)) {
            this.printReasonForForcingContainerIdAsHostId("Container's network mode is host");
            return true;
        }
        return false;
    }

    private void printReasonForForcingContainerIdAsHostId(String reason) {
        log.debug("Container will use Container ID as Host ID. Reason: {}", (Object)reason);
    }
}

