/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.crashguard;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.agent.extensions.api.events.EventsService;
import com.appdynamics.sim.agent.extensions.crashguard.AppAgentMonitorInfoResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Provider;
import com.singularity.ee.agent.crashdetect.DetectedJVM;
import com.singularity.ee.agent.crashdetect.JVMProcessPersistenceFile;
import com.singularity.ee.agent.crashdetect.JvmCrashData;
import com.singularity.ee.agent.resolver.AgentRegistrationInfo;
import com.singularity.ee.agent.util.StringEncoder;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.events.EventMessage;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicBooleanImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.Slf4JLogger;
import com.singularity.ee.util.spi.IAgentAtomicBoolean;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SigarAppAgentMonitor
implements Runnable {
    private static final String NAME = SigarAppAgentMonitor.class.getSimpleName();
    private static final String JAVAAGENT_ARG = "-javaagent:";
    private static final String APP_AGENT_NODE_DIR = "appdynamics.agent.node.dir";
    private static final String APPDYNAMICS_AGENT_RUNTIME_DIR_ENV_VAR = "APPDYNAMICS_AGENT_BASE_DIR";
    private static final String APPDYNAMICS_AGENT_RUNTIME_DIR = "appdynamics.agent.runtime.dir";
    private static final String USE_PROC_FILES_PROP_NAME = "appdynamics.use.proc.files.for.process.info";
    private static final String PROC_DIR_PROP_NAME = "appdynamics.proc.dir.name";
    private static final String CONF_DIR_NAME = "conf";
    private boolean useProcFiles;
    private String procDirName;
    private final Map<Long, DetectedJVM> mapOfAllJVMProcesses;
    private final Set<Long> setOfAllKnownPIDs;
    private final Provider<Optional<String>> accountKey;
    private static final Logger logger = LoggerFactory.getLogger(SigarAppAgentMonitor.class);
    private Sigar sigar;
    private EventsService eventsService;
    private BootstrapConfiguration bootstrapConfiguration;
    private boolean permissionDeniedExceptionOccurred;
    private static final IAgentAtomicBoolean objectCreated = new AgentAtomicBooleanImpl(false);

    static SigarAppAgentMonitor reserveAndCreateInstance(@NonNull Sigar sigar, @NonNull EventsService eventsService, @NonNull BootstrapConfiguration bootstrapConfiguration, @NonNull Provider<Optional<String>> accountKeyProvider) throws DuplicateObjectException {
        if (sigar == null) {
            throw new NullPointerException("sigar is marked non-null but is null");
        }
        if (eventsService == null) {
            throw new NullPointerException("eventsService is marked non-null but is null");
        }
        if (bootstrapConfiguration == null) {
            throw new NullPointerException("bootstrapConfiguration is marked non-null but is null");
        }
        if (accountKeyProvider == null) {
            throw new NullPointerException("accountKeyProvider is marked non-null but is null");
        }
        if (!objectCreated.compareAndSet(false, true)) {
            throw new DuplicateObjectException();
        }
        return new SigarAppAgentMonitor(sigar, eventsService, bootstrapConfiguration, accountKeyProvider);
    }

    static void releaseReservation() {
        objectCreated.set(false);
    }

    private SigarAppAgentMonitor(Sigar sigar, EventsService eventService, BootstrapConfiguration bootstrapConfiguration, Provider<Optional<String>> accountKey) {
        this.sigar = sigar;
        this.eventsService = eventService;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.mapOfAllJVMProcesses = new HashMap<Long, DetectedJVM>();
        this.setOfAllKnownPIDs = new HashSet<Long>();
        this.useProcFiles = StringOperations.safeParseBoolean((String)SystemUtils.getProperty((String)USE_PROC_FILES_PROP_NAME), (boolean)false);
        this.procDirName = SystemUtils.getProperty((String)PROC_DIR_PROP_NAME, (String)"proc");
        this.accountKey = accountKey;
    }

    @Override
    public void run() {
        try {
            HashSet<Long> nonDiscoveredPids = new HashSet<Long>(this.setOfAllKnownPIDs);
            long[] listOfProcesses = this.sigar.getProcList();
            if (listOfProcesses != null) {
                for (long nextPid : listOfProcesses) {
                    Long lPid = nextPid;
                    if (!nonDiscoveredPids.contains(lPid)) {
                        this.examinePid(nextPid);
                        this.setOfAllKnownPIDs.add(lPid);
                        continue;
                    }
                    nonDiscoveredPids.remove(lPid);
                }
            }
            Object object = nonDiscoveredPids.iterator();
            while (object.hasNext()) {
                DetectedJVM detectedJVM;
                Long nextDeletedPid = (Long)object.next();
                this.setOfAllKnownPIDs.remove(nextDeletedPid);
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("Discovered that pid %d is no longer active", nextDeletedPid));
                }
                if ((detectedJVM = this.mapOfAllJVMProcesses.remove(nextDeletedPid)) == null || this.eventsService == null) continue;
                Optional accountKeyOpt = (Optional)this.accountKey.get();
                if (accountKeyOpt.isPresent()) {
                    JvmCrashData crashData = detectedJVM.getJVMCrashData(this.bootstrapConfiguration.getControllerHost(), (String)accountKeyOpt.get(), this.bootstrapConfiguration.getHostId());
                    if (crashData == null) continue;
                    this.sendError(crashData.getEventDetailsMap(), crashData.getMachineId(), crashData.getNodeId());
                    continue;
                }
                logger.error("Not reporting any jvm crashes because the account key is absent");
            }
        }
        catch (SigarException se) {
            logger.error(se.toString(), (Throwable)se);
        }
    }

    void sendError(Map<String, String> eventDetails, String machineId, long nodeID) {
        Optional machineIdOptLong = Optional.absent();
        if (machineId != null) {
            machineIdOptLong = Optional.of((Object)Long.parseLong(machineId));
        }
        Optional subtypeOpt = Optional.of((Object)"JVM Crash Detected");
        Optional triggeredEntityOpt = Optional.absent();
        if (nodeID > 0L) {
            EntityDefinition triggeredEntity = new EntityDefinition();
            triggeredEntity.setEntityType(EntityType.APPLICATION_COMPONENT_NODE);
            triggeredEntity.setEntityId(nodeID);
            triggeredEntityOpt = Optional.of((Object)triggeredEntity);
        }
        this.eventsService.reportEvent(ClockUtils.getCurrentTime(), NotificationSeverity.ERROR, EventType.APPLICATION_CRASH, eventDetails, EventMessage.JVM_CRASHED, machineIdOptLong, subtypeOpt, triggeredEntityOpt);
    }

    @VisibleForTesting
    void examinePid(long pid) {
        block16: {
            try {
                DetectedJVM newDetectedAppAgent;
                String cwd;
                Map<String, String> procEnvVars;
                String[] args;
                block15: {
                    if (logger.isTraceEnabled()) {
                        logger.trace(String.format("Examining pid %d", pid));
                    }
                    args = null;
                    procEnvVars = null;
                    cwd = null;
                    if (this.useProcFiles || this.permissionDeniedExceptionOccurred) {
                        args = this.getCommandLineArgsFromProcFiles(pid);
                        cwd = this.getCWDFromProcFiles(pid);
                        procEnvVars = this.getEnvVarsFromProcFiles(pid);
                    }
                    if (args == null) {
                        args = this.sigar.getProcArgs(pid);
                        if (logger.isTraceEnabled() && args != null) {
                            logger.trace(String.format("Got %d command line arguments for pid %d from Sigar", args.length, pid));
                        }
                    }
                    if (!(procEnvVars != null && cwd != null || this.permissionDeniedExceptionOccurred)) {
                        try {
                            ProcExe procExe;
                            if (cwd == null && (procExe = this.sigar.getProcExe(pid)) != null) {
                                cwd = procExe.getCwd();
                                if (logger.isTraceEnabled() && cwd != null) {
                                    logger.trace(String.format("Got current working directory %s for pid %d from Sigar", cwd, pid));
                                }
                            }
                            if (procEnvVars == null) {
                                procEnvVars = this.getSigarEnv(pid);
                                if (logger.isTraceEnabled() && procEnvVars != null) {
                                    logger.trace(String.format("Got %d environmental variables for pid %d from Sigar", procEnvVars.size(), pid));
                                }
                            }
                        }
                        catch (SigarPermissionDeniedException e) {
                            this.permissionDeniedExceptionOccurred = true;
                            logger.info(String.format("Exception %s occurred trying to obtain process information for process %d - Unable to create JVM Crash errors for non-instrumented JVMs", e.toString(), pid));
                            if (this.useProcFiles) break block15;
                            if (cwd == null) {
                                cwd = this.getCWDFromProcFiles(pid);
                            }
                            if (procEnvVars != null) break block15;
                            procEnvVars = this.getEnvVarsFromProcFiles(pid);
                        }
                    }
                }
                if (args != null && (newDetectedAppAgent = this.createDetectedJVM(pid, args, cwd, procEnvVars)) != null) {
                    this.mapOfAllJVMProcesses.put(pid, newDetectedAppAgent);
                }
            }
            catch (SigarException se) {
                if (!logger.isTraceEnabled()) break block16;
                logger.trace(se.toString(), (Throwable)se);
            }
        }
    }

    private Map<String, String> getSigarEnv(long pid) throws SigarException {
        return this.sigar.getProcEnv(pid);
    }

    private DetectedJVM createDetectedJVM(long pid, String[] args, String cwd, Map<String, String> procEnvVars) {
        String command;
        DetectedJVM returnObject = null;
        if (args.length >= 1 && ((command = args[0].trim()).endsWith("java") || command.endsWith("java.exe"))) {
            HashMap<String, String> javaProps = new HashMap<String, String>();
            String installDir = this.searchForAgentDir(args, 1, cwd, javaProps);
            String javaToolOptions = null;
            if (procEnvVars != null) {
                javaToolOptions = procEnvVars.get("JAVA_TOOL_OPTIONS");
            }
            if (javaToolOptions != null) {
                String[] parsedOptions = javaToolOptions.split(" ");
                String installDirFromJavaOptionsProp = this.searchForAgentDir(parsedOptions, 0, cwd, javaProps);
                if (installDir == null) {
                    installDir = installDirFromJavaOptionsProp;
                }
            }
            String javaOptions = null;
            if (procEnvVars != null) {
                javaOptions = procEnvVars.get("_JAVA_OPTIONS");
            }
            if (javaOptions != null) {
                String[] parsedOptions = javaOptions.split(" ");
                String installDirFromJavaOptionsProp = this.searchForAgentDir(parsedOptions, 0, cwd, javaProps);
                if (installDir == null) {
                    installDir = installDirFromJavaOptionsProp;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Pid %d is a Java process - found %d properties on command line", pid, javaProps.size()));
            }
            returnObject = this.createDetectedJVM(pid, installDir, cwd, procEnvVars, javaProps, args);
        }
        return returnObject;
    }

    private String searchForAgentDir(String[] javaArgs, int startIndex, String cwd, Map<String, String> javaProps) {
        String returnString = null;
        for (int i = startIndex; i < javaArgs.length; ++i) {
            String[] parsedProp;
            String nextArg = javaArgs[i].trim();
            if (nextArg.startsWith(JAVAAGENT_ARG)) {
                String javaAgentLocation = this.getAgentInstallDirectory(nextArg.substring(JAVAAGENT_ARG.length()), cwd);
                if (javaAgentLocation == null) continue;
                returnString = javaAgentLocation;
                continue;
            }
            if (!nextArg.startsWith("-D") || (parsedProp = nextArg.substring(2).split("=")).length != 2) continue;
            javaProps.put(parsedProp[0], parsedProp[1]);
        }
        return returnString;
    }

    private DetectedJVM createDetectedJVM(long pid, String installDir, String cwd, Map<String, String> procEnvVars, Map<String, String> props, String[] commandLineArguments) {
        Slf4JLogger iLogger = new Slf4JLogger(logger);
        AgentRegistrationInfo regInfo = null;
        String runtimeDirectory = null;
        if (installDir != null) {
            String controllerConfigFile = installDir + File.separator + CONF_DIR_NAME + File.separator + "controller-info.xml";
            String versionSpecificControllerConfigFile = null;
            runtimeDirectory = this.getAgentRuntimeDirectory(installDir, procEnvVars, props);
            String versionSpecificDirectory = this.getVersionDirectoryForPid(pid, runtimeDirectory != null ? runtimeDirectory : installDir, (ILogger)iLogger);
            if (versionSpecificDirectory != null) {
                versionSpecificControllerConfigFile = versionSpecificDirectory + File.separator + CONF_DIR_NAME + File.separator + "controller-info.xml";
            }
            String[] configPaths = null;
            if (new File(controllerConfigFile).exists()) {
                configPaths = versionSpecificControllerConfigFile != null && new File(versionSpecificControllerConfigFile).exists() ? new String[]{versionSpecificControllerConfigFile, controllerConfigFile} : new String[]{controllerConfigFile};
            } else if (versionSpecificControllerConfigFile != null && new File(versionSpecificControllerConfigFile).exists()) {
                configPaths = new String[]{versionSpecificControllerConfigFile};
            }
            AppAgentMonitorInfoResolver infoResolver = configPaths != null ? new AppAgentMonitorInfoResolver(configPaths, (ILogger)iLogger, procEnvVars, props) : new AppAgentMonitorInfoResolver((ILogger)iLogger, procEnvVars, props);
            infoResolver.run();
            regInfo = infoResolver.getAgentRegistrationInfo();
        }
        DetectedJVM returnObject = new DetectedJVM(pid, runtimeDirectory, cwd, commandLineArguments, procEnvVars, regInfo, System.currentTimeMillis(), new StringEncoder(), (ILogger)iLogger);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("DetectedJVM has been created for pid %d", pid));
        }
        return returnObject;
    }

    private String getAgentInstallDirectory(String javaAgentArgValue, String cwd) {
        String returnString = null;
        String[] parsedJavaAgent = javaAgentArgValue.split("=");
        try {
            if (parsedJavaAgent.length > 0 && parsedJavaAgent[0].endsWith("javaagent.jar")) {
                File installDir = new File(parsedJavaAgent[0]).getParentFile();
                if (installDir != null && installDir.exists()) {
                    returnString = installDir.getCanonicalPath();
                } else if (cwd != null && !parsedJavaAgent[0].startsWith(File.separator) && (installDir = new File(new File(cwd), parsedJavaAgent[0]).getParentFile()) != null && installDir.exists()) {
                    returnString = installDir.getCanonicalPath();
                }
            }
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        return returnString;
    }

    private String getAgentNodeDirectory(String installDir, Map<String, String> props) {
        String returnValue = props.get(APP_AGENT_NODE_DIR);
        if (returnValue == null) {
            returnValue = installDir;
        }
        return returnValue;
    }

    private String getAgentRuntimeDirectory(String installDir, Map<String, String> procEnvVars, Map<String, String> props) {
        String runtimeDir;
        String string = runtimeDir = procEnvVars != null ? procEnvVars.get(APPDYNAMICS_AGENT_RUNTIME_DIR_ENV_VAR) : null;
        if (runtimeDir == null && (runtimeDir = props.get(APPDYNAMICS_AGENT_RUNTIME_DIR)) == null) {
            runtimeDir = this.getAgentNodeDirectory(installDir, props);
        }
        return runtimeDir;
    }

    private String getCWDFromProcFiles(long pid) {
        String cwd = null;
        try {
            File cwdDir;
            File procDir = this.getProcDirectoryForProcess(pid);
            if (procDir != null && (cwdDir = new File(procDir, "cwd")).isDirectory()) {
                cwd = cwdDir.getCanonicalPath();
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("Found home directory %s for process %d", cwd, pid));
                }
            }
        }
        catch (Throwable e) {
            logger.debug(String.format("%s exception caught attempting to determine home directory for process %d", e, pid));
        }
        return cwd;
    }

    private Map<String, String> getEnvVarsFromProcFiles(long pid) {
        HashMap<String, String> envVars = null;
        try {
            String[] environFileContents;
            File environFile;
            File procDir = this.getProcDirectoryForProcess(pid);
            if (procDir != null && (environFile = new File(procDir, "environ")).exists() && (environFileContents = this.loadProcFile(environFile)) != null) {
                envVars = new HashMap<String, String>(environFileContents.length);
                for (String nextEnvVar : environFileContents) {
                    int indexOfEqual = nextEnvVar.indexOf(61);
                    if (indexOfEqual <= 0) continue;
                    String key = nextEnvVar.substring(0, indexOfEqual);
                    String value = nextEnvVar.substring(indexOfEqual + 1);
                    envVars.put(key, value);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace(String.format("Found environment variable %s=%s for process %d", key, value, pid));
                }
            }
        }
        catch (Throwable e) {
            logger.debug(String.format("%s exception caught attempting to determine environmental variables for process %d", e, pid));
            envVars = null;
        }
        return envVars;
    }

    @VisibleForTesting
    String[] getCommandLineArgsFromProcFiles(long pid) {
        String[] returnArgs = null;
        try {
            File cmdLineFile;
            File procDir = this.getProcDirectoryForProcess(pid);
            if (procDir != null && (cmdLineFile = new File(procDir, "cmdline")).exists()) {
                returnArgs = this.loadProcFile(cmdLineFile);
                if (logger.isTraceEnabled() && returnArgs != null) {
                    for (String nextArg : returnArgs) {
                        logger.trace(String.format("Found command line argument %s for process %d", nextArg, pid));
                    }
                }
            }
        }
        catch (IOException e) {
            logger.debug(String.format("%s exception caught attempting to determine command line argument for process %d", e, pid));
        }
        return returnArgs;
    }

    @VisibleForTesting
    File getProcDirectoryForProcess(long pid) {
        File procDir = new File(File.separator + this.procDirName + File.separator + Long.toString(pid));
        if (!procDir.isDirectory()) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("File %s does not exist or is not a directory", procDir));
            }
            procDir = null;
        }
        return procDir;
    }

    @VisibleForTesting
    String[] loadProcFile(File file) throws IOException {
        String[] returnStringArray = null;
        ArrayList<byte[]> listOfBuffers = new ArrayList<byte[]>();
        byte[] currentBuffer = new byte[1000];
        int totalBytesRead = 0;
        try (FileInputStream fis = new FileInputStream(file);){
            int numRead;
            while ((numRead = fis.read(currentBuffer)) >= 0) {
                totalBytesRead += numRead;
                byte[] smallerBuffer = new byte[numRead];
                System.arraycopy(currentBuffer, 0, smallerBuffer, 0, numRead);
                listOfBuffers.add(smallerBuffer);
            }
        }
        byte[] totalBuffer = null;
        if (listOfBuffers.size() == 1) {
            totalBuffer = (byte[])listOfBuffers.get(0);
        } else if (listOfBuffers.size() > 1) {
            totalBuffer = new byte[totalBytesRead];
            int copyOffset = 0;
            for (byte[] nextBuffer : listOfBuffers) {
                System.arraycopy(nextBuffer, 0, totalBuffer, copyOffset, nextBuffer.length);
                copyOffset += nextBuffer.length;
            }
        }
        if (totalBuffer != null) {
            returnStringArray = this.parseBuffer(totalBuffer);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("File %s has been read - %d bytes", file, returnStringArray.length));
            }
        }
        return returnStringArray;
    }

    private String[] parseBuffer(byte[] buffer) {
        int startPos;
        ArrayList<String> listOfContents = new ArrayList<String>();
        for (int i = startPos = 0; i < buffer.length; ++i) {
            if (buffer[i] != 0) continue;
            int length = i - startPos;
            if (length > 0) {
                String nextString = new String(buffer, startPos, length, Charset.forName("UTF-8"));
                listOfContents.add(nextString);
            }
            startPos = i + 1;
        }
        return listOfContents.toArray(new String[listOfContents.size()]);
    }

    private String getVersionDirectoryForPid(long pid, String runtimeDirectory, ILogger logger) {
        String returnString = null;
        JVMProcessPersistenceFile processPersistenceFile = JVMProcessPersistenceFile.locateProcessPersistenceFileForPid((long)pid, (String)(runtimeDirectory + File.separator + CONF_DIR_NAME), (ILogger)logger);
        if (processPersistenceFile != null) {
            returnString = processPersistenceFile.getVersionDirectory();
        }
        return returnString;
    }

    @Generated
    public Map<Long, DetectedJVM> getMapOfAllJVMProcesses() {
        return this.mapOfAllJVMProcesses;
    }

    @Generated
    void setPermissionDeniedExceptionOccurred(boolean permissionDeniedExceptionOccurred) {
        this.permissionDeniedExceptionOccurred = permissionDeniedExceptionOccurred;
    }

    static class DuplicateObjectException
    extends Exception {
        DuplicateObjectException() {
            super("Duplicate " + NAME + " created");
        }
    }
}

