/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.metrics.model;

import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.containerd.metrics.model.ContainerComponent;
import com.google.common.base.Optional;

public abstract class ContainerDisk<RAWDATA>
implements ContainerComponent<RAWDATA> {
    private final MetricsService metricsService;
    private boolean firstTime = true;

    protected ContainerDisk(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    @Override
    public void report() {
        if (!this.firstTime) {
            Optional<Long> diskIOUtiliazation;
            Optional<Long> diskQueueSize;
            Optional<Long> diskWriteKbPerSec;
            Optional<Long> diskReadKbPerSec;
            Optional<Long> diskWriteCountPerSec;
            Optional<Long> diskReadCountPerSec = this.getDiskReadCountPerSec();
            if (diskReadCountPerSec.isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Disks|Reads/sec", ExtensionMetricAggregatorType.AVERAGE, ((Long)diskReadCountPerSec.get()).longValue());
            }
            if ((diskWriteCountPerSec = this.getDiskWriteCountPerSec()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Disks|Writes/sec", ExtensionMetricAggregatorType.AVERAGE, ((Long)diskWriteCountPerSec.get()).longValue());
            }
            if ((diskReadKbPerSec = this.getDiskReadKbPerSec()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Disks|KB read/sec", ExtensionMetricAggregatorType.AVERAGE, ((Long)diskReadKbPerSec.get()).longValue());
            }
            if ((diskWriteKbPerSec = this.getDiskWriteKbPerSec()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Disks|KB written/sec", ExtensionMetricAggregatorType.AVERAGE, ((Long)diskWriteKbPerSec.get()).longValue());
            }
            if ((diskQueueSize = this.getDiskQueueSize()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Disks|Queue size", ExtensionMetricAggregatorType.AVERAGE, ((Long)diskQueueSize.get()).longValue());
            }
            if ((diskIOUtiliazation = this.getDiskIOUtilization()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Disks|Avg IO Utilization (%)", ExtensionMetricAggregatorType.AVERAGE, ((Long)diskIOUtiliazation.get()).longValue());
            }
        }
        this.firstTime = false;
    }

    protected Optional<Long> getDiskIOUtilization() {
        Optional ioUtilization = Optional.absent();
        Optional<Double> diskServiceTimePerSecond = this.getDiskServiceTimePerSec();
        if (diskServiceTimePerSecond.isPresent()) {
            ioUtilization = Optional.of((Object)Math.round((Double)diskServiceTimePerSecond.get() * 100.0));
        }
        return ioUtilization;
    }

    protected abstract Optional<Long> getDiskReadCountPerSec();

    protected abstract Optional<Long> getDiskWriteCountPerSec();

    protected abstract Optional<Long> getDiskReadKbPerSec();

    protected abstract Optional<Long> getDiskWriteKbPerSec();

    protected abstract Optional<Long> getDiskQueueSize();

    protected abstract Optional<Double> getDiskServiceTimePerSec();
}

