/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.metrics.model;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.ReportingUtil;
import com.appdynamics.sim.agent.extensions.containerd.metrics.model.ContainerComponent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerCpu<RAWDATA>
implements ContainerComponent<RAWDATA> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerCpu.class);
    private static final long DEFAULT_LOGICAL_CORES = 1L;
    private final MetricsService metricsService;
    private boolean firstTime = true;
    private BootstrapConfiguration bootstrapConfiguration;

    protected ContainerCpu(MetricsService metricsService, BootstrapConfiguration bootstrapConfiguration) {
        this.metricsService = metricsService;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    @Override
    public void report() {
        if (!this.firstTime) {
            Optional<Long> cpuThrottledTime;
            Optional<Long> cpuBusyScaled;
            Optional<Long> cpuBusy = this.getCpuBusy();
            if (cpuBusy.isPresent()) {
                if (this.bootstrapConfiguration.getContainerOldCpuMetricKeyEnabled().booleanValue()) {
                    this.metricsService.reportMetric("Hardware Resources|CPU|%Busy", ExtensionMetricAggregatorType.AVERAGE, ((Long)cpuBusy.get()).longValue());
                } else {
                    this.metricsService.reportMetric("Hardware Resources|CPU|%Busy (Container)", ExtensionMetricAggregatorType.AVERAGE, ((Long)cpuBusy.get()).longValue());
                }
            }
            if ((cpuBusyScaled = this.getCpuBusyScaled()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|CPU|%Busy Scaled", ExtensionMetricAggregatorType.AVERAGE, ((Long)cpuBusyScaled.get()).longValue());
            }
            if ((cpuThrottledTime = this.getCpuThrottledTime()).isPresent()) {
                ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|CPU|Throttled Time (ms)", (long)TimeUnit.NANOSECONDS.toMillis((Long)cpuThrottledTime.get()));
            }
        }
        this.firstTime = false;
    }

    @VisibleForTesting
    public long calculateHostLogicalCores(Map<String, String> hostProperties) {
        long returnValue = 1L;
        String hostLogicalCores = hostProperties.get("Total|CPU|Logical Processor Count");
        if (hostLogicalCores != null) {
            try {
                returnValue = Long.valueOf(hostLogicalCores);
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to convert the host's logical core, raw data: {}", (Object)hostLogicalCores);
            }
        }
        return returnValue;
    }

    public abstract Optional<Long> getCpuBusy();

    public abstract Optional<Long> getCpuBusyScaled();

    public abstract Optional<Long> getCpuThrottledTime();
}

