/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.metrics;

import com.appdynamics.agent.sim.containerd.model.ContainerdContainerDto;
import com.appdynamics.agent.sim.lightagent.LightAgentRegistry;
import com.appdynamics.agent.sim.lightagent.LightSystemAgent;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.containerd.metrics.ContainerdContainerMetricsFactory;
import com.appdynamics.sim.agent.extensions.containerd.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.containerd.metrics.collector.ContainerMetricsRawCollector;
import com.appdynamics.sim.agent.extensions.containerd.metrics.model.ContainerMetrics;
import com.appdynamics.voltron.utils.TimeSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerMetricsCollectionManager<RAWDATA> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerMetricsCollectionManager.class);
    private ContainerMetricsRawCollector<RAWDATA> containerMetricsRawCollector;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final LightAgentRegistry lightAgentRegistry;
    private Map<String, ContainerMetrics<RAWDATA>> containerMetricsMap;
    private final ContainerdContainerMetricsFactory<RAWDATA> containerdContainerMetricsFactory;
    private final TimeSupplier timeSupplier;
    private final MachineProperties serverHostProperties;

    @Inject
    @VisibleForTesting
    ContainerMetricsCollectionManager(ContainerMetricsRawCollector<RAWDATA> containerMetricsRawCollector, SimAgentRepetitiveLogger repetitiveLogger, LightAgentRegistry lightAgentRegistry, ContainerdContainerMetricsFactory<RAWDATA> containerdContainerMetricsFactory, TimeSupplier timeSupplier, MachineProperties serverHostProperties) {
        this.containerMetricsRawCollector = containerMetricsRawCollector;
        this.repetitiveLogger = repetitiveLogger;
        this.lightAgentRegistry = lightAgentRegistry;
        this.containerMetricsMap = Collections.emptyMap();
        this.containerdContainerMetricsFactory = containerdContainerMetricsFactory;
        this.timeSupplier = timeSupplier;
        this.serverHostProperties = serverHostProperties;
    }

    public void collectAndReport(List<ContainerdContainerDto> containers, Set<ContainerComponentName> componentNames) {
        this.containerMetricsMap = this.buildContainerMetricsMap(containers);
        long startTime = this.timeSupplier.get();
        Map<String, RAWDATA> containersRawData = this.containerMetricsRawCollector.collect(containers, componentNames);
        long endTime = this.timeSupplier.get();
        log.debug("Total time in collecting metrics for {} out of {} containers is : {} (ms)", new Object[]{containersRawData.size(), containers.size(), endTime - startTime});
        for (ContainerdContainerDto container : containers) {
            ContainerMetrics<RAWDATA> containerMetrics = this.containerMetricsMap.get(container.getId());
            RAWDATA rawdata = containersRawData.get(container.getId());
            if (rawdata == null) {
                this.repetitiveLogger.warn(log, "No data collected for container - {}", new Object[]{container.getId()});
                continue;
            }
            try {
                if (containerMetrics == null) continue;
                containerMetrics.update(containersRawData.get(container.getId()), componentNames, this.serverHostProperties);
                containerMetrics.report(componentNames);
            }
            catch (RuntimeException exception) {
                this.repetitiveLogger.warn(log, "Error while reporting metrics for container - {} with components - {}", new Object[]{container.getId(), componentNames});
            }
        }
    }

    @VisibleForTesting
    public Map<String, ContainerMetrics<RAWDATA>> buildContainerMetricsMap(List<ContainerdContainerDto> containers) {
        ImmutableMap.Builder containerStatsMapBuilder = new ImmutableMap.Builder();
        for (ContainerdContainerDto container : containers) {
            try {
                String containerId = container.getId();
                ContainerMetrics<RAWDATA> containerMetrics = this.containerMetricsMap.get(containerId);
                if (containerMetrics == null) {
                    Optional lightSystemAgentOptional = this.lightAgentRegistry.getAgent(containerId);
                    if (lightSystemAgentOptional.isPresent()) {
                        MetricsService metricsService = ((LightSystemAgent)this.lightAgentRegistry.getAgent(containerId).get()).getMetricsService();
                        MachineProperties machineProperties = ((LightSystemAgent)this.lightAgentRegistry.getAgent(containerId).get()).getContainerProperties();
                        containerMetrics = this.containerdContainerMetricsFactory.make(metricsService, machineProperties);
                        containerStatsMapBuilder.put((Object)containerId, containerMetrics);
                        continue;
                    }
                    this.repetitiveLogger.warn(log, "LightAgent not found in LightAgentRegistry for container - {}", new Object[]{containerId});
                    continue;
                }
                containerStatsMapBuilder.put((Object)containerId, containerMetrics);
            }
            catch (RuntimeException e) {
                this.repetitiveLogger.warn(log, "Failed to add container - {} to the ContainerdApiContainerMetrics map.", new Object[]{container.getId(), e});
            }
        }
        return containerStatsMapBuilder.build();
    }
}

