/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd;

import com.appdynamics.agent.sim.containerd.model.ContainerdContainerFull;
import com.appdynamics.agent.sim.dmm.SimMachineIdSupplier;
import com.appdynamics.agent.sim.lightagent.LightAgentRegistry;
import com.appdynamics.agent.sim.lightagent.LightSystemAgent;
import com.appdynamics.agent.sim.lightagent.LightSystemAgentFactory;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.agent.sim.registration.AgentConfigFactory;
import com.appdynamics.agent.sim.tags.DefaultMachineTags;
import com.appdynamics.agent.sim.tags.DefaultMachineTagsFactory;
import com.appdynamics.agent.sim.tags.MachineTagMapName;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.containerd.ContainerdContainerSystemInfo;
import com.appdynamics.sim.common.biz.shared.machines.AgentRegistrationConfig;
import com.appdynamics.sim.common.biz.shared.machines.AgentRegistrationSupplementalRequest;
import com.appdynamics.sim.common.rest.machines.ContainerType;
import com.appdynamics.sim.common.rest.machines.GenericConfig;
import com.appdynamics.sim.common.rest.machines.SimMachineFullDto;
import com.appdynamics.sim.common.rest.machines.SimMachineMinimalDto;
import com.appdynamics.sim.common.rest.machines.SimMachineTypeDto;
import com.appdynamics.sim.common.rest.machines.SimMachinesAgentService;
import com.appdynamics.voltron.utils.TimeSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerdRegistrationTask
implements Callable<LightSystemAgent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdRegistrationTask.class);
    private static final boolean MARK_HISTORICAL = true;
    private static final String CONTAINERS = "Containers";
    private final SimMachinesAgentService simMachinesAgentService;
    private final MachineProperties hostServerMachineProperties;
    private final LightSystemAgentFactory lightSystemAgentFactory;
    private final AgentConfigFactory agentConfigFactory;
    private final LightAgentRegistry lightAgentRegistry;
    private final SimMachineIdSupplier simHostMachineIdSupplier;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final TimeSupplier timeSupplier;
    private final ContainerdContainerFull containerdContainerFull;
    private final boolean isMarkHistorical;
    private final DefaultMachineTagsFactory defaultMachineTagsFactory;

    @Inject
    public ContainerdRegistrationTask(SimMachinesAgentService simMachinesAgentService, LightSystemAgentFactory lightSystemAgentFactory, AgentConfigFactory agentConfigFactory, MachineProperties hostServerMachineProperties, LightAgentRegistry lightAgentRegistry, SimMachineIdSupplier simHostMachineIdSupplier, TimeSupplier timeSupplier, SimAgentRepetitiveLogger repetitiveLogger, DefaultMachineTagsFactory defaultMachineTagsFactory, @Assisted ContainerdContainerFull containerdContainerFull, @Assisted boolean isMarkHistorical) {
        this.simMachinesAgentService = simMachinesAgentService;
        this.lightSystemAgentFactory = lightSystemAgentFactory;
        this.agentConfigFactory = agentConfigFactory;
        this.hostServerMachineProperties = hostServerMachineProperties;
        this.lightAgentRegistry = lightAgentRegistry;
        this.simHostMachineIdSupplier = simHostMachineIdSupplier;
        this.timeSupplier = timeSupplier;
        this.repetitiveLogger = repetitiveLogger;
        this.containerdContainerFull = containerdContainerFull;
        this.isMarkHistorical = isMarkHistorical;
        this.defaultMachineTagsFactory = defaultMachineTagsFactory;
    }

    @VisibleForTesting
    LightSystemAgent registerLightSystemAgent(@NonNull ContainerdContainerFull containerdContainerFull) {
        if (containerdContainerFull == null) {
            throw new NullPointerException("containerdContainerFull is marked non-null but is null");
        }
        return this.registerLightSystemAgent(containerdContainerFull, false);
    }

    @VisibleForTesting
    LightSystemAgent registerLightSystemAgent(@NonNull ContainerdContainerFull containerdContainerFull, boolean historical) {
        LightSystemAgent lightSystemAgent;
        if (containerdContainerFull == null) {
            throw new NullPointerException("containerdContainerFull is marked non-null but is null");
        }
        String containerId = containerdContainerFull.getId();
        String hostId = containerdContainerFull.getHostId();
        String hostName = containerdContainerFull.getHostName();
        ImmutableList machineHierarchy = ImmutableList.of((Object)CONTAINERS);
        HashMap registrationProperties = Maps.newHashMap((Map)this.hostServerMachineProperties.toMap());
        Map containerPropertiesMap = Collections.emptyMap();
        boolean isFirstRegistration = true;
        registrationProperties.put("AppDynamics|Agent|Machine Info", ContainerdContainerSystemInfo.getMachineInfo(containerdContainerFull));
        Optional lightSystemAgentOptional = this.lightAgentRegistry.getAgent(containerId);
        if (lightSystemAgentOptional.isPresent()) {
            isFirstRegistration = false;
            MachineProperties containerProperties = ((LightSystemAgent)lightSystemAgentOptional.get()).getContainerProperties();
            containerPropertiesMap = containerProperties.toMap();
            if (((LightSystemAgent)lightSystemAgentOptional.get()).getContainerType().isPresent()) {
                registrationProperties.put("CONTAINER_TYPE", ((ContainerType)((LightSystemAgent)lightSystemAgentOptional.get()).getContainerType().get()).name());
            }
        }
        Map tags = Collections.emptyMap();
        HashMap<MachineTagMapName, SetMultimap> tagMap = new HashMap<MachineTagMapName, SetMultimap>();
        if (containerdContainerFull.getContainerPropertiesDto().getConfig().getLabels() != null && !containerdContainerFull.getContainerPropertiesDto().getConfig().getLabels().isEmpty()) {
            tagMap.put(MachineTagMapName.CONTAINERD_INTEGRATION_TAG_MAP, Multimaps.forMap((Map)containerdContainerFull.getContainerPropertiesDto().getConfig().getLabels()));
        }
        Map k8sTagsMap = containerdContainerFull.getK8sContainerTags();
        log.debug("Size of k8s tags: " + k8sTagsMap.size());
        if (log.isTraceEnabled()) {
            StringBuilder logStrBuilder = new StringBuilder("Reporting K8s labels: ");
            for (Map.Entry entry : k8sTagsMap.entrySet()) {
                logStrBuilder.append((String)entry.getKey()).append(" - ").append((String)entry.getValue());
            }
            log.trace(logStrBuilder.toString());
        }
        tagMap.put(MachineTagMapName.K8S_INTEGRATION_TAG_MAP, Multimaps.forMap((Map)k8sTagsMap));
        DefaultMachineTags machineTags = this.defaultMachineTagsFactory.create(tagMap);
        if (machineTags != null) {
            tags = Multimaps.asMap((SetMultimap)machineTags.toMap());
        }
        SimMachineMinimalDto requestDto = this.createMachineRequestDto(hostId, hostName, isFirstRegistration, (List<String>)machineHierarchy, containerPropertiesMap, registrationProperties, tags, historical);
        log.trace("Running containerd collector task with input {}", (Object)requestDto);
        SimMachineFullDto response = this.simMachinesAgentService.registerMachine(requestDto);
        AgentRegistrationConfig config = this.getFromControllerConfig(response.getControllerConfig());
        String machineId = config.getMachineInstanceEntityId();
        Long simMachineId = response.getId();
        if (!lightSystemAgentOptional.isPresent() || !machineId.equals(((LightSystemAgent)lightSystemAgentOptional.get()).getMachineInstanceId())) {
            String machineInstanceId = config.getMachineInstanceEntityId();
            lightSystemAgent = this.lightSystemAgentFactory.create(machineInstanceId, simMachineId.longValue());
            this.lightAgentRegistry.registerAgent(containerId, lightSystemAgent);
        } else {
            lightSystemAgent = (LightSystemAgent)lightSystemAgentOptional.get();
        }
        lightSystemAgent.setLastRegisteredTime(this.timeSupplier.get());
        lightSystemAgent.setContainerType(this.extractContainerType(response.getControllerConfig()));
        log.debug("Registered container {}, with hostname {} to machine instance {}", new Object[]{containerId, hostId, lightSystemAgent.getMachineInstanceId()});
        return lightSystemAgent;
    }

    @VisibleForTesting
    Optional<ContainerType> extractContainerType(GenericConfig controllerConfig) {
        Optional agentRegistrationSupplementalRequestOptional = controllerConfig.of("_agentRegistrationSupplementalConfig", AgentRegistrationSupplementalRequest.class);
        if (agentRegistrationSupplementalRequestOptional.isPresent()) {
            String containerType = ((AgentRegistrationSupplementalRequest)agentRegistrationSupplementalRequestOptional.get()).getContainerType();
            if (containerType == null) {
                return Optional.absent();
            }
            ContainerType type = ContainerType.valueOf((String)containerType);
            return Optional.of((Object)type);
        }
        return Optional.absent();
    }

    @VisibleForTesting
    AgentRegistrationConfig getFromControllerConfig(GenericConfig configuration) {
        Optional agentRegistrationConfigOptional = configuration.of("_agentRegistrationConfig", AgentRegistrationConfig.class);
        return (AgentRegistrationConfig)agentRegistrationConfigOptional.get();
    }

    @VisibleForTesting
    SimMachineMinimalDto createMachineRequestDto(String hostId, String hostName, boolean isFirstRegistration, List<String> machineHierarchy, Map<String, String> containerPropertiesMap, Map<String, String> agentPropertiesMap, Map<String, Set<String>> tags, boolean markHistorical) {
        Long simHostMachineId = null;
        if (this.simHostMachineIdSupplier.get().isPresent()) {
            simHostMachineId = (Long)this.simHostMachineIdSupplier.get().get();
        }
        SimMachineMinimalDto requestDto = new SimMachineMinimalDto(hostId, hostId, machineHierarchy, containerPropertiesMap, tags, this.agentConfigFactory.createAgentConfig(isFirstRegistration, agentPropertiesMap, null, null, null, SimMachineTypeDto.CONTAINER, Optional.fromNullable((Object)simHostMachineId), markHistorical, Optional.fromNullable((Object)hostName)));
        return requestDto;
    }

    @Override
    public LightSystemAgent call() {
        try {
            return this.registerLightSystemAgent(this.containerdContainerFull, this.isMarkHistorical);
        }
        catch (Exception e) {
            this.repetitiveLogger.debug(log, "Error registering containerId : " + this.containerdContainerFull.getId() + "  with error {}", new Object[]{e});
            log.trace("Error registering containerId : {}  with error {}", (Object)this.containerdContainerFull.getId(), (Object)e);
            return null;
        }
    }

    @Generated
    public ContainerdRegistrationTask(SimMachinesAgentService simMachinesAgentService, MachineProperties hostServerMachineProperties, LightSystemAgentFactory lightSystemAgentFactory, AgentConfigFactory agentConfigFactory, LightAgentRegistry lightAgentRegistry, SimMachineIdSupplier simHostMachineIdSupplier, SimAgentRepetitiveLogger repetitiveLogger, TimeSupplier timeSupplier, ContainerdContainerFull containerdContainerFull, boolean isMarkHistorical, DefaultMachineTagsFactory defaultMachineTagsFactory) {
        this.simMachinesAgentService = simMachinesAgentService;
        this.hostServerMachineProperties = hostServerMachineProperties;
        this.lightSystemAgentFactory = lightSystemAgentFactory;
        this.agentConfigFactory = agentConfigFactory;
        this.lightAgentRegistry = lightAgentRegistry;
        this.simHostMachineIdSupplier = simHostMachineIdSupplier;
        this.repetitiveLogger = repetitiveLogger;
        this.timeSupplier = timeSupplier;
        this.containerdContainerFull = containerdContainerFull;
        this.isMarkHistorical = isMarkHistorical;
        this.defaultMachineTagsFactory = defaultMachineTagsFactory;
    }

    @Generated
    public ContainerdContainerFull getContainerdContainerFull() {
        return this.containerdContainerFull;
    }
}

