/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.rest;

import com.appdynamics.sim.agent.extensions.api.events.EventsService;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.rest.AgentLegacyResource;
import com.appdynamics.sim.agent.extensions.rest.AgentResource;
import com.appdynamics.sim.agent.extensions.rest.ServerConfiguration;
import com.appdynamics.sim.agent.extensions.rest.exceptionmapper.JsonMappingExceptionMapper;
import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.net.InetSocketAddress;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import lombok.Generated;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AgentServerRunner
implements ConfigurationListener<ServerConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentServerRunner.class);
    @Generated
    private final Object $lock = new Object[0];
    private final MetricsService metricsService;
    private final EventsService eventsService;
    private Optional<Server> serverOpt;
    private ServerConfiguration prevConfig;

    @Inject
    AgentServerRunner(MetricsService metricsService, EventsService eventsService) {
        this.metricsService = metricsService;
        this.eventsService = eventsService;
        this.serverOpt = Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(String configName, ServerConfiguration configuration) {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Applying {}", (Object)configuration);
            if (configuration != null && !configuration.equals(this.prevConfig)) {
                try {
                    this.stopServer();
                    this.startServer(configuration);
                }
                catch (Exception exception) {
                    log.warn("Could not restart the agent server to apply configuration change.", (Throwable)exception);
                }
                this.prevConfig = new ServerConfiguration(configuration.getEnabled(), configuration.getPort(), configuration.getHost());
            }
        }
    }

    private void startServer(ServerConfiguration configuration) throws Exception {
        if (!this.serverOpt.isPresent()) {
            if (configuration.getEnabled().booleanValue()) {
                Server server = this.buildServer(configuration);
                this.serverOpt = Optional.of((Object)server);
                log.debug("Starting internal server for agent API");
                server.start();
            } else {
                log.debug("Agent REST API disabled.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stopServer() throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            if (this.serverOpt.isPresent()) {
                log.debug("Stopping internal server for agent API");
                ((Server)this.serverOpt.get()).stop();
                this.serverOpt = Optional.absent();
            }
        }
    }

    private Server buildServer(ServerConfiguration serverConfiguration) {
        log.info("Building API server to run on {}:{}", (Object)serverConfiguration.getHost(), (Object)serverConfiguration.getPort());
        Server server = new Server(new InetSocketAddress(serverConfiguration.getHost(), (int)serverConfiguration.getPort()));
        ServletContextHandler servletContextHandler = new ServletContextHandler((Handler.Container)server, "/", 1);
        ServletContainer servletContainer = new ServletContainer(new Application(){

            public Set<Object> getSingletons() {
                return ImmutableSet.of((Object)new AgentResource(AgentServerRunner.this.metricsService, AgentServerRunner.this.eventsService), (Object)new AgentLegacyResource(AgentServerRunner.this.metricsService, AgentServerRunner.this.eventsService));
            }

            public Set<Class<?>> getClasses() {
                return ImmutableSet.of(JsonMappingExceptionMapper.class);
            }
        });
        ServletHolder servletHolder = new ServletHolder((Servlet)servletContainer);
        servletHolder.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
        servletContextHandler.addServlet(servletHolder, "/*");
        return server;
    }

    @VisibleForTesting
    protected ServerConfiguration getPrevConfig() {
        return this.prevConfig;
    }
}

