/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.rest;

import com.appdynamics.sim.agent.extensions.api.events.EventSeverity;
import com.appdynamics.sim.agent.extensions.api.events.EventsService;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.rest.api.LegacyAgentRestApi;
import com.appdynamics.sim.agent.extensions.rest.api.LegacyAgentRestXmlMetricRequest;
import com.appdynamics.sim.agent.extensions.rest.api.LegacyAgentRestXmlResponse;
import com.appdynamics.sim.agent.extensions.rest.api.LegacyAgentXmlMetricItem;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentLegacyResource
implements LegacyAgentRestApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentLegacyResource.class);
    private static final Map<String, ExtensionMetricAggregatorType> METRIC_TYPES = ImmutableMap.of((Object)"sum", (Object)ExtensionMetricAggregatorType.SUM, (Object)"average", (Object)ExtensionMetricAggregatorType.AVERAGE, (Object)"current", (Object)ExtensionMetricAggregatorType.OBSERVATION);
    private static final Map<String, EventSeverity> EVENT_TYPES = ImmutableMap.of((Object)"error", (Object)EventSeverity.ERROR, (Object)"info", (Object)EventSeverity.INFO, (Object)"warning", (Object)EventSeverity.WARN);
    private final MetricsService metricsService;
    private final EventsService eventsService;

    AgentLegacyResource(MetricsService metricsService, EventsService eventsService) {
        this.metricsService = metricsService;
        this.eventsService = eventsService;
    }

    @Override
    public Void writeMetricsViaGet(String name, long value, String type) {
        ExtensionMetricAggregatorType aggregatorType = METRIC_TYPES.get(type.toLowerCase());
        if (aggregatorType == null) {
            log.info("Attempted to write metrics with bad type {}", (Object)type);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unknown type " + type + ". Please use one of " + Arrays.toString(METRIC_TYPES.keySet().toArray()))).build());
        }
        this.metricsService.reportMetric(name, aggregatorType, value);
        return null;
    }

    @Override
    public LegacyAgentRestXmlResponse writeMetricsViaPost(LegacyAgentRestXmlMetricRequest metricsRequest) {
        for (LegacyAgentXmlMetricItem metricItem : metricsRequest.getMetrics()) {
            this.writeMetricsViaGet(metricItem.getName(), metricItem.getValue(), metricItem.getType());
        }
        return LegacyAgentRestXmlResponse.createSuccessResponse("Metric Upload Successful");
    }

    @Override
    public Void writeEvents(String severity, String summary) {
        EventSeverity eventSeverity = EVENT_TYPES.get(severity.toLowerCase());
        if (eventSeverity == null) {
            log.info("Attempted to write events with bad severity {}", (Object)severity);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unknown type " + severity + ". Please use one of " + Arrays.toString(EVENT_TYPES.keySet().toArray()))).build());
        }
        this.eventsService.reportCustomEvent(eventSeverity, "CUSTOM", summary, Collections.emptyMap(), Collections.emptyMap());
        return null;
    }
}

